*******************************************************************************
*
InitTools           start
*
* Description:      Load and initialize the tools I need. Errors are detected
*                   and FatalError is called if any occur. If there aren't any
*                   errors, the list of menu templates is read and our menu-
*                   bar is created.
*
*
* Inputs:           NONE
*
* Outputs:          NONE
*
* External Refs:
*                   Import FatalError
*
* Entry Points:     NONE
*
*******************************************************************************
                    using Globals

;
;   Tool Direct page offsets here
;
QDDPage             equ $0000
EMDPage             equ QDDPage+$0300
CtlDPage            equ EMDPage+$0100
MenuDPage           equ CtlDPage+$0100
LEDPage             equ MenuDPage+$0100
FMDPage             equ LEDPage+$0100
ListDPage           equ FMDPage+$0100
PMDPage             equ ListDPage+$0100
ToolDPSize          equ PMDPage+$0200

                    phk                 ; Save program bank register
                    plb                 ; and load it as the data bank register

                    tdc
                    sta MyDP            ; Save direct register

                    _TLStartup          ; Start Tool Locator

                    pha                 ; Space for result
                    _MMStartup          ; Start memory manager
                    PullWord MyID       ; Save it for later use

                    _MTStartup          ; Start up Misc Tools

                    _IMStartup          ; Start integer math toolset

                    PushLong #ToolTable ; Pointer to Tool table
                    _LoadTools          ; Load all RAM based tools
                    bcc IT0005          ; Carry clear means no error
                    brl FatalError      ; Tools can't be loaded. Fatal error!

IT0005              ANOP

; Get memory for Tool Direct pages

                    pha                 ; Room for result
                    pha
                    PushLong #ToolDPSize ; Number of bytes needed
                    PushWord MyID       ; ID of this application
                    PushWord #attrLocked+attrFixed+attrPage+attrBank
                    PushLong #0         ; Allocate them in bank 0
                    _NewHandle
                    bcc IT0010          ; Test carry for error
                    brl FatalError      ; If no memory we got a fatal error!

IT0010              PullLong DPHandle   ; Retrieve handle to our DPage area

                    lda [DPHandle]      ; Dereference the handle to get a ptr
                    sta DPPointer       ; to our direct page area and save it.

                    PushWord DPPointer  ; QuickDraw uses 3 pages of Dpage
                    PushWord #ScreenMode ; Used to set all master SCB's
                    PushWord #0         ; Zero means use default buf size
                    PushWord MyID       ; Application ID for allocating data
                    _QDStartup          ; Start QuickDraw, turn on SHR Screen
                    bcc IT0015
                    brl FatalError      ; If it can't be started then bomb

IT0015              _QDAuxStartUp

                    lda DPPointer       ; Create address for Event Mgr DPage by
                    clc                 ; loading in the pointer to the start
                    adc #EMDPage        ; of DPage and adding Evt Mgr offset.
                    pha                 ; Now push it on the stack.
                    PushWord #20        ; Size of event queue.
                    PushWord #0         ; MouseClamp values.
                    PushWord #ScreenWidth ; These will clamp mouse to screen
                    PushWord #0         ; area only.
                    PushWord #200
                    PushWord MyID
                    _EMStartup          ; Start the event manager
                    bcc IT0020
                    brl FatalError      ; Event manager is also a must
IT0020              ANOP
                    PushWord MyID
                    _WindStartup
                    bcc IT0025
                    brl FatalError
IT0025              ANOP
                    PushWord MyID
                    lda DPPointer
                    clc
                    adc #CtlDPage
                    pha
                    _CtlStartup
                    bcc IT0030
                    brl FatalError
IT0030              ANOP

                    PushWord MyID
                    lda DPPointer
                    clc
                    adc #MenuDPage
                    pha
                    _MenuStartUp
                    bcc IT0035
                    brl FatalError
IT0035              ANOP

                    PushWord MyID
                    lda DPPointer
                    clc
                    adc #LEDPage
                    pha
                    _LEStartUp
                    bcc IT0040
                    brl FatalError
IT0040              ANOP

                    PushWord MyID
                    _DialogStartup
                    bcc IT0045
                    brl FatalError
IT0045              ANOP

                    _ScrapStartup       ; No errors possible for this call

                    _DeskStartup        ; No error possible for this call

; insert application specific tools here

                    PushWord MyID
                    lda DPPointer
                    clc
                    adc #FMDPage
                    pha
                    _FMStartUp
                    bcc IT0050
                    brl FatalError
IT0050              ANOP

                    _ListStartup

                    PushWord MyID
                    lda DPPointer
                    clc
                    adc #PMDPage
                    pha
                    _PMStartUp
                    bcc IT0055
                    brl FatalError
IT0055              ANOP

                    PushLong #0
                    _RefreshDeskTop

;
; Create the menus I need
;

                    ldx #MenuPtrLen-4   ; Get a pointer to the last menu        
loop                phx                 ; Save menu table index on the stack
                    pha                 ; Push on space for the menu handle
                    pha                 ;   returned by NewMenu
                    lda MenuPtr+2,x     ; Push on the pointer to the template
                    pha                 ;   to be used by NewMenu when
                    lda MenuPtr,x       ;   creating the menu
                    pha
                    _NewMenu            ; Create a new menu
                    PushWord #0         ; Tell InsertMenu where to put it
                    _InsertMenu         ; Insert it.
                    plx                 ; Get our index back off the stack
                    dex                 ; Point to the next template pointer
                    dex
                    dex
                    dex
                    bpl loop            ; Go back up if not done yet.

                    PushWord #1         ; Add NDA's
                    _FixAppleMenu

                    PushWord #0         ; Now call CalcMenuSize for all menus
                    _FixMenuBar
                    PullWord MenuHeight

                    _DrawMenuBar        ; Finally, draw it.

                    RTS

ToolTable           dc i2'10'           ; Data Block for LoadTools call
                    dc i2'14,$0100'     ; Window Manager
                    dc i2'15,$0100'     ; Menu Manager
                    dc i2'16,$0100'     ; Control Manager
                    dc i2'18,$0100'     ; QD Aux
                    dc i2'19,$0100'     ; Print Manager
                    dc i2'20,$0100'     ; LineEdit tool set
                    dc i2'21,$0100'     ; Dialog Manager
                    dc i2'22,$0100'     ; Scrap manager
                    dc i2'27,$0100'     ; Font Manager
                    dc i2'28,$0100'     ; List Manager

                    end

                    EJECT
*******************************************************************************
*
FatalError          start
*
* Description:      Routine that is called whenever a tool sends back an error
*                   that can not be recovered from. This routine prints the
*                   error on the screen, waits for a keypress then quits back
*                   to whoever started this application up!
*
*
* Inputs:           A = Error number
*
* Outputs:          NONE (program exits)
*
* External Refs:
*                   Import CloseTools
*
* Entry Points:     NONE
*
*******************************************************************************
                    using Globals

                    pha                 ; Push the error code
                    PushLong #ErrNumStr ; Address of storage area
                    PushWord #4         ; Length of string
                    _Int2Hex

                    _GrafOff            ; If QD Started, shut off graphics

                    PushLong #ErrStr    ; Write error message to the screen
                    _WriteCString

                    pha                 ; Space for result
                    PushWord #0         ; No echo
                    _ReadChar           ; Wait for a key to be pressed
                    pla                 ; Discard the key

                    jsr CloseTools      ; Shut down all the tools in case
;                                         any got started up

                    _Quit QuitParms     ; Quit back to where we came from.

                    brk $FF             ; If the quit fails then just break
                    
ErrStr              dc c'A fatal error has occured $'
ErrNumStr           dc c'xxxx   press any key to exit',i1'0'

                    end

                    EJECT
*******************************************************************************
*
CloseTools          start
*
* Description:      Shut down the tools I started.
*
*
* Inputs:           NONE
*
* Outputs:          NONE
*
* External Refs:    NONE
*
* Entry Points:     NONE
*
*******************************************************************************
                    using Globals

                    _PMShutDown
                    _ListShutDown
                    _FMShutDown
                    _DeskShutDown
                    _ScrapShutDown
                    _DialogShutDown
                    _LEShutDown
                    _MenuShutDown
                    _CtlShutDown
                    _WindShutDown

                    _EMShutDown
                    _QDAuxShutdown
                    _QDShutDown
                    _MTShutDown

                    PushLong DPHandle   ; Dispose of all that DP memory
                    _DisposeHandle

                    PushWord MyID
                    _MMShutDown
                    _TLShutDown

                    rts
                    end

                    EJECT
*******************************************************************************
*
doAbout             start
*
* Description:      Bring up an Alert Dialog box with my name in it.
*
* Inputs:           NONE
*
* Outputs:          NONE
*
* External Refs:    NONE
*
* Entry Points:     NONE
*
*******************************************************************************
                    using Globals

                    pha                 ; space for result
                    PushLong #AboutBox  ; pointer to dialog template
                    PushLong #0         ; pointer to a filter proc
                    _NoteAlert
                    pla                 ; get the item hit and dispose

                    rts

; About Box alert template

AboutBox            dc i2'30,30,100,590'                    ; for 320 use 30,30,100,290
                    dc i2'1'            ; this is alert # 1
                    dc i1'$80'          ; draw for this stage
                    dc i1'$81'          ; draw for this stage
                    dc i1'$82'          ; draw for this stage
                    dc i1'$83'          ; draw for this stage
                    dc i4'OKButton'     ; ok button for the alert
                    dc i4'AboutTitle'   ; title of the program
                    dc i4'AboutAut'     ; author
                    dc i4'AboutVers'    ; version number string
                    dc i4'0'            ; nil to end the list

OKBTitle            dc i1'2',c'OK'
OKButton            dc i2'1'
                    dc i2'50,500,65,550'
                    dc i2'buttonItem'
                    dc i4'OKBTitle'
                    dc i2'0'
                    dc i2'0'            ; item flag
                    dc i4'0'            ; no color table

AboutTitle          dc i2'2'
                    dc i2'10,100,20,550'
                    dc i2'statText+itemDisable'
                    dc i4'TitleString'
                    dc i2'0'
                    dc i2'0'            ; item flag
                    dc i4'0'            ; no color table

AboutAut            dc i2'3'
                    dc i2'25,100,35,550'
                    dc i2'statText+itemDisable'
                    dc i4'AutString'
                    dc i2'0'
                    dc i2'0'            ; item flag
                    dc i4'0'            ; no color table

AboutVers           dc i2'4'
                    dc i2'40,100,50,550'
                    dc i2'statText+itemDisable'
                    dc i4'VersString'
                    dc i2'0'
                    dc i2'0'            ; item flag
                    dc i4'0'            ; no color table

                    end
